<?php
// cms/api/surveys/updatequestions.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("surveyid","type","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    // Si type viene con cero se borran todas las preguntas y sale
    if ($_REQUEST["type"]=="0") {
        $sql="DELETE FROM surveyquestions WHERE surveyid=".$_REQUEST["surveyid"];
        if (!$db->query($sql)) 
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $out = new stdClass;    
        $out->id =(integer)$_REQUEST["surveyid"];
        header("HTTP/1.1 200");
        echo (json_encode($out));
        die();            
    }    
        
    if (!isset($_REQUEST["dsc_esp"]) && !isset($_REQUEST["dsc_eng"]) && !isset($_REQUEST["dsc_por"]))
        badEnd("400", array("msg"=>"Debe indicar una descripcion"));
    elseif (strlen($_REQUEST["dsc_esp"])==0 && strlen($_REQUEST["dsc_eng"])==0 && strlen($_REQUEST["dsc_por"])==0)
        badEnd("400", array("msg"=>"Debe indicar una descripcion"));        



    $arraytypes=explode("-",$_REQUEST["type"]);
    $preguntas_esp=explode("|",$_REQUEST["dsc_esp"]);
    $preguntas_eng=explode("|",$_REQUEST["dsc_eng"]);
    $preguntas_por=explode("|",$_REQUEST["dsc_por"]);
    
    // Si la encuesta no existe se manda error 204
    $sqlCnt =  "SELECT COUNT(*) cnt FROM surveys WHERE id=".$_REQUEST["surveyid"];
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    if ($numofrecords==0) 
        badEnd("204", array("msg"=>"No existe esa encuesta"));
    
    // Si la encuesta ya tiene preguntas, se borran las preguntas y las opciones antes de insertar las nuevas
    $sqlCnt =  "SELECT COUNT(*) cnt FROM surveyquestions WHERE surveyid=".$_REQUEST["surveyid"];
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    if ($numofrecords>0) {
        $sql="DELETE FROM surveyquestions WHERE surveyid=".$_REQUEST["surveyid"];
        if (!$db->query($sql)) 
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }

    //** Insertar nuevas preguntas
    
    //determinar cuantas preguntas hay en español
    for ($max_esp=1; isset($_REQUEST["options_esp".$max_esp]); $max_esp++);
    $max_esp--;

    //determinar cuantas preguntas hay en ingles
    for ($max_eng=1; isset($_REQUEST["options_eng".$max_eng]); $max_eng++);
    $max_eng--;    

    //determinar cuantas preguntas hay en portugues
    for ($max_por=1; isset($_REQUEST["options_por".$max_por]); $max_por++);
    $max_por--;
    
    $max=max($max_esp,$max_eng,$max_por);
    if ($max_esp>0)
        $index_esp=0;
    if ($max_eng>0)
        $index_eng=0;
    if ($max_por>0)
        $index_por=0;
    $check=array();
    for($x=0;$x<$max;$x++) {
        $columns="id,surveyid,type";
        $values = "0,".$_REQUEST["surveyid"].",".$arraytypes[$x];


        if (count($arraytypes)<>$max)
            badEnd("400", array("msg"=>"Cantidad de tipo de pregunta no coincide con el nmero de preguntas"));
        
        if ($index_esp < $max_esp) {
            $columns.=", dsc_esp ";
            $values .=", '".$preguntas_esp[$index_esp]."'";
        }
        if ($index_eng < $max_eng) {
            $columns.=", dsc_eng ";
            $values .=", '".$preguntas_eng[$index_eng]."'";
        }
        if ($index_por < $max_por) {
            $columns.=", dsc_por ";
            $values .=", '".$preguntas_por[$index_por]."'";
        }

        $index_esp++;
        $index_eng++;
        $index_por++;

        // campo order es obligatorio para el insert
        $columns = $columns.",ord";
        $values = $values.",0 ";
        
        $sql="INSERT INTO surveyquestions (".$columns.") VALUES (".$values.")";
        if (!$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $id =$db->insert_id;
        $i=$x+1;
        $opciones_esp=explode("|",$_REQUEST["options_esp".$i]);
        $opciones_eng=explode("|",$_REQUEST["options_eng".$i]);
        $opciones_por=explode("|",$_REQUEST["options_por".$i]);
        $maxoptions_esp=count($opciones_esp);
        $maxoptions_eng=count($opciones_eng);
        $maxoptions_por=count($opciones_por);
        $maxoptions=max($maxoptions_esp,$maxoptions_eng,$maxoptions_por);
        if ($maxoptions_esp>0)
            $indexoptions_esp=0;
        if ($maxoptions_eng>0)
            $indexoptions_eng=0;
        if ($maxoptions_por>0)
            $indexoptions_por=0;

        // Insertar opciones 
        for ($y=0;$y<$maxoptions;$y++) {
    
            $columns="id,questionid";
            $values = "0,".$id;
            
            if ($indexoptions_esp < $maxoptions_esp) {
                $columns.=", option_esp ";
                $values .=", '".$opciones_esp[$indexoptions_esp]."'";
            }
            if ($indexoptions_eng < $maxoptions_eng) {
                $columns.=", option_eng ";
                $values .=", '".$opciones_eng[$indexoptions_eng]."'";
            }
            if ($indexoptions_por < $maxoptions_por) {
                $columns.=", option_por ";
                $values .=", '".$opciones_por[$indexoptions_por]."'";
            }
    
            $indexoptions_esp++;
            $indexoptions_eng++;
            $indexoptions_por++;        
    
            $sql="INSERT INTO surveyoptions (".$columns.") VALUES (".$values.")";
            if (!$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

            
        }
    }

//------ Actualizar Cache
    //Buscar id del evento
    $sql =  "SELECT eventid FROM surveys WHERE id=".$_REQUEST["surveyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $eventid=$row["eventid"];
    
    if(!actualizarCache($db,$eventid,'event', 0)) 
        badEnd("500", array("msg"=>"Error actualizando cache"));
//------Fin Actualizar Cache        

    $out = new stdClass;    
    $out->id =(integer)$_REQUEST["surveyid"];
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>