<?php
// app/api/sponsors/entry.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    isSessionValidCMS($db,$_REQUEST["sessionid"]);


    $sql="SELECT id, name, weight, imagetype, tags, dsc_esp, dsc_eng, dsc_por,  ".
        " email, website, facebook, twitter, instagram, linkedin " .
        " FROM sponsors ".
        " WHERE id=".$_REQUEST["id"];

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name"],"");
        $record->weight=(integer)nvl($row["weight"],"");
        // Imagen
        if (!is_null($row["imagetype"])) {
            switch ($row["imagetype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
            }
            $record->image=$homeurl."uploads/sponsors/".$row["id"].$ext;
        }
        else
            $record->image="";
        // Fin imagen        
        $record->tags=nvl($row["tags"],"");       
        $dsc = array("esp"=>nvl($row["dsc_esp"],""), "eng"=>nvl($row["dsc_eng"],""), "por"=>nvl($row["dsc_por"],""));     
        $record->dsc=$dsc;
        $record->email=nvl($row["email"],"");
        $record->website=nvl($row["website"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
        
    }
    
    $out= new stdClass;
    $out->entry=$record;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>