<?php
// cms/api/sites/update

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("id","eventid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    $columns="id,eventid";
    $values=$_REQUEST["id"].",".$_REQUEST["eventid"];
    $updatelist = "eventid=".$_REQUEST["eventid"];

    // parametros opcionales
    if (isset($_REQUEST["tags"])){
        $columns = $columns.",tags";
        $values = $values.",'".$_REQUEST["tags"]."'";
        $updatelist = $updatelist.",tags='".$_REQUEST["tags"]."'";
    }
    if (isset($_REQUEST["coords"])){
        $columns = $columns.",coords";
        $values = $values.",'".$_REQUEST["coords"]."'";
        $updatelist = $updatelist.",coords='".$_REQUEST["coords"]."'";
    }
    $flagname=0;
    $flagdsc=0;

    
    if (isset($_REQUEST["name_eng"]) && trim($_REQUEST["name_eng"])!=""){
        $flagname=1;
        $columns = $columns.",name_eng";
        $values = $values.",'".$_REQUEST["name_eng"]."'";
        $updatelist = $updatelist.",name_eng='".$_REQUEST["name_eng"]."'";
    }
    if (isset($_REQUEST["name_esp"]) && trim($_REQUEST["name_esp"])!="" ){
        $flagname=1;
        $columns = $columns.",name_esp";
        $values = $values.",'".$_REQUEST["name_esp"]."'";
        $updatelist = $updatelist.",name_esp='".$_REQUEST["name_esp"]."'";
    }
    if (isset($_REQUEST["name_por"]) && trim($_REQUEST["name_por"])!=""){
        $flagname=1;
        $columns = $columns.",name_por";
        $values = $values.",'".$_REQUEST["name_por"]."'";
        $updatelist = $updatelist.",name_por='".$_REQUEST["name_por"]."'";
    }

    if (isset($_REQUEST["dsc_eng"]) && trim($_REQUEST["dsc_eng"])!=""){
        $flagdsc=1;
        $columns = $columns.",dsc_eng";
        $values = $values.",'".str_replace("'","''",$_REQUEST["dsc_eng"])."'";
        $updatelist = $updatelist.",dsc_eng='".str_replace("'","''",$_REQUEST["dsc_eng"])."'";
    }
    if (isset($_REQUEST["dsc_esp"])&& trim($_REQUEST["dsc_esp"])!=""){
        $flagdsc=1;        
        $columns = $columns.",dsc_esp";
        $values = $values.",'".str_replace("'","''",$_REQUEST["dsc_esp"])."'";
        $updatelist = $updatelist.",dsc_esp='".str_replace("'","''",$_REQUEST["dsc_esp"])."'";
    }
    if (isset($_REQUEST["dsc_por"]) && trim($_REQUEST["dsc_por"])!=""){
        $flagdsc=1;        
        $columns = $columns.",dsc_por";
        $values = $values.",'".str_replace("'","''",$_REQUEST["dsc_por"])."'";
        $updatelist = $updatelist.",dsc_por='".str_replace("'","''",$_REQUEST["dsc_por"])."'";
    }

    if(!$flagname || !$flagdsc)
        badEnd("400", array("msg"=>"Debe indicar al menos un nombre y al menos una descripcion"));
        
    if ($_REQUEST["id"]==0) { 
        // Es un insert
        $sql="INSERT INTO sites (".$columns.") VALUES (".$values.")";
        if (!$db->query($sql)) {
            if ($db->errno == 1062){
                badEnd("304", array("msg"=>"Registro Duplicado"));
            }
            else {
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
        }
        $id =$db->insert_id;
    }
    else {
        // Es un update
        // Validar que existe el registro
        $sql="SELECT COUNT(*) Cnt FROM sites WHERE id=".$_REQUEST["id"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $row = $rs->fetch_assoc();
        if ($row["Cnt"]==0)
            badEnd("204", array('msg'=>"El registro no existe"));
        $sql="UPDATE sites SET ".$updatelist." WHERE id=".$_REQUEST["id"];
        if (!$db->query($sql)) 
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $id=$_REQUEST["id"];    
    }
    if (!isset($id))
        $id=$_REQUEST["id"]; 

    // ------ Cargar archivo de imagen
    if (isset($_REQUEST["imageids"]))
        $imageids=explode("-",$_REQUEST["imageids"]);
        
    if (isset($_REQUEST["imageids"]) && count($imageids)>0){
        $newimages=array();
        $i=1;
        foreach ($imageids as $value) {
            if ($value==0) {
                $newimages[]="IMAGE".$i;
                $i++;
            }
        }
        if (count($_FILES)<>count($newimages))
            badEnd("400", array("msg"=>"La cantidad de imagenes cargadas no es igual a la cantidad de imagenes nuevas indicadas con ceros"));
        $images= array();
        $index=0;
        //Si no existe el directorio del site para las imagenes, se crea
        $dir='../../uploads/sites/'.$id;
        if (!file_exists($dir)) {
            if (!@mkdir($dir)){
                badEnd("500", array(id=>2,msg=>$error['message']));
            }
        }
        //Si existe, busco un listado de los archivos del directorio
        else {
            $a = scandir($dir);
            //Lleno el arreglo de estructura con datos de los archivos, todos son candidatos a borrar
            for($i=2; $i<count($a); $i++) {
                $imageobj= new stdClass;
                $imageobj->id=(integer)substr($a[$i], 0, strpos($a[$i], '.'));
                $ext=substr($a[$i],-3);
                $imageobj->type="image/".$ext;
                $imageobj->url="../../uploads/sites/".$_REQUEST["id"]."/".$imageobj->id.".".$ext;
                $imageobj->todelete=true;
                $images[]=$imageobj;
            }
        }
        //En caso de que existan imagenes las busco y las marco para no borrar
        if (count($images)>0) {
            foreach ($images as $value) {
                foreach ($imageids as $x) {
                    if ($value->id==$x) {
                        $value->todelete=false;
                        break;
                    }
                }
            }
            //Borrar los marcados y guardar maximo indice
            foreach($images as $value) {
                if ($value->todelete) {
                    $source=$dir."/".$value->id.".".substr($value->type,-3);
                    if (!unlink($source))
                        badEnd("500", array("id"=>3,"msg"=>$error['message']));
                }
                else 
                    $index= $value->id;
            }
        }
        //Grabar imagenes nuevas
        if (count($newimages)>0) {
            foreach ($newimages as $IMAGE) {
                if (isset($_FILES[$IMAGE])){
                    if (!$_FILES[$IMAGE]["tmp_name"])
                        badEnd("500", array("id"=>0,msg=>"Archivo no enviado"));
                    switch ($_FILES[$IMAGE]["type"]){
                        case "image/png":
                            $ext = ".png";
                            break;
                        case "image/jpeg":
                        case "image/jpg":
                            $ext = ".jpg";
                            break;
                        default:
                            badEnd("500", array(id=>1,msg=>"El formato del documento debe ser PNG o JPG"));
                    }
                    $ruta='../../uploads/sites/'.$id.'/'.++$index.$ext;
                    if(!move_uploaded_file($_FILES[$IMAGE]["tmp_name"], $ruta))
                        badEnd("500", array(id=>2,msg=>"Error en funcion move_uploaded_file"));
                }
            }
                
        }
    }
    //------ Fin Cargar archivo de imagen 

//------ Actualizar Cache
    $eventid=$_REQUEST["eventid"];
    
    if(!actualizarCache($db,$eventid,'event', 0)) 
        badEnd("500", array("msg"=>"Error actualizando cache"));
//------Fin Actualizar Cache      
    
    
    $out = new stdClass;    
    $out->id =(integer)$id;
    //$out->imagenes=$newimages;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
