<?php
// cms/api/sites/entry

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    //Seleccionar idioma por defecto del evento. 
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE status=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
        //if (substr_count($row["activelanguages"],"esp")>0)
        //    $defaultlang="esp";
    }        
    
    // seleccionar el idioma del name
    switch ($defaultlang) {
        case "esp":
            $name="name_esp";
            break;
        case "eng":
            $name="name_eng";
            break;
        case "por":
            $name="name_por";
            break;
    }     
    
    //**Se buscan las actividades asociadas a ese sitio
    $sql="SELECT A.id,".$name." AS name FROM activities A WHERE A.siteid=".$_REQUEST["id"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $arrayactivities=array();
    while ($row = $rs->fetch_assoc()) {
        $activity = new stdClass;
        $activity->id=$row["id"];
        $activity->name=$row["name"];
        $arrayactivities[]=$activity;
    }
    //**

    // Query principal
    $sql="SELECT id, name_esp, name_eng, name_por, tags, coords, dsc_eng, dsc_esp, dsc_por ".
        " FROM sites ".
        " WHERE id= ".$_REQUEST["id"];
    
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=new stdClass;
        $record->name->esp=nvl($row["name_esp"],"");
        $record->name->eng=nvl($row["name_eng"],"");
        $record->name->por=nvl($row["name_por"],"");        
        $record->coords=nvl($row["coords"],"");
        $record->tags=nvl($row["tags"],"");            
        $arraydsc=array("esp"=>nvl($row["dsc_esp"],""), "eng"=>nvl($row["dsc_eng"],""), "por"=>nvl($row["dsc_por"],""));
        $record->dsc=$arraydsc;
        // Imagen
        $dir = "../../uploads/sites/".$_REQUEST["id"]."/";

        if (file_exists($dir)) {
            $a = scandir($dir);
            $numoffiles=count($a);
            //Lleno arreglo de estructura con datos de los archivos
            $images= array();
            for($i=2; $i<$numoffiles; $i++) {
                $imageobj= new stdClass;
                $imageobj->id=(integer)substr($a[$i], 0, strpos($a[$i], '.'));
                $ext=substr($a[$i],-3);
                $imageobj->type="image/".$ext;
                $imageobj->url="./uploads/sites/".$_REQUEST["id"]."/".$imageobj->id.".".$ext;
                $images[]=$imageobj;
            }
            $record->images=$images;
        }
        else
            $record->images=array();
        //Fin imagen
        $record->activities=$arrayactivities;
    }
    
    $out= new stdClass;
    $out->entry=$record;
    //$out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>