<?php
// app/api/reports/surveys.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("eventid","order","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    

    // Seleccionar el evento activo y los idiomas disponibles
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE id=".$_REQUEST["eventid"];
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"Evento no disponible"));
    $eventid=$rowevent["id"];
    $languages=explode(",",$rowevent["activelanguages"]);



    $outputlanguage = $rowevent["defaultlang"];

    //Obtener el id del usuario logueado
    isSessionValidCMS($db,$_REQUEST["sessionid"]);


    // order
    //1=Nombre de la Encuesta, 2=Descripci贸n, 3=Nro de Respuestas (Valores negativos es el orden inverso)
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY S.name_".$outputlanguage." ".$type;
            break;
        case 2:
            $strorderby=" ORDER BY S.dsc_".$outputlanguage." ".$type;
            break;
        case 3:
            $strorderby=" ORDER BY COUNT(DISTINCT S.id, SR.appuserid) ".$type;
            break;
        default:
            badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
    }   
   

    // queries de los totales
    
    //answered
    $sql = "SELECT COUNT(DISTINCT S.id, SR.appuserid) as answered "
    . "FROM surveys S "
    . "LEFT JOIN surveyquestions SQ ON "
    . "    SQ.surveyid = S.id "
    . "LEFT JOIN surveyresponses SR ON "
    . "    SR.surveyquestionid = SQ.id "
    . "WHERE "
    . "    S.eventid = $eventid AND SR.closed = 1 "
    . "ORDER BY S.id, SR.appuserid";

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if($row = $rs->fetch_assoc())
        $answered=$row["answered"];
    else
        $answered=0;

    //users
    $sql = "SELECT COUNT(DISTINCT(SR.appuserid )) AS users "
    . "	FROM  surveys S LEFT JOIN surveyquestions SQ ON SQ.surveyid=S.id "
    . "	LEFT JOIN surveyresponses SR ON SR.surveyquestionid=SQ.id "
    . "WHERE S.eventid = $eventid "
    . "AND SR.closed=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if($row = $rs->fetch_assoc())
        $users=$row["users"];
    else
        $users=0;

    //saved
    $sql = "SELECT COUNT(DISTINCT S.id, SR.appuserid) saved "
    . "FROM surveys S "
    . "LEFT JOIN surveyquestions SQ ON "
    . "    SQ.surveyid = S.id "
    . "LEFT JOIN surveyresponses SR ON "
    . "    SR.surveyquestionid = SQ.id "
    . "WHERE "
    . "    S.eventid = $eventid AND SR.closed = 0 "
    . "ORDER BY S.id, SR.appuserid";

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if($row = $rs->fetch_assoc())
        $saved=$row["saved"];
    else
        $saved=0;

    //responses
    $sql = "SELECT "
    . "    S.id, "
    . "    S.name_esp, S.name_eng, S.name_por, "
    . "    S.dsc_esp, S.dsc_eng, S.dsc_por, "
    . "    COUNT(DISTINCT S.id, SR.appuserid) responses "
    . "FROM "
    . "    surveys S "
    . "LEFT JOIN surveyquestions SQ ON "
    . "    SQ.surveyid = S.id "
    . "LEFT JOIN surveyresponses SR ON "
    . "    SR.surveyquestionid = SQ.id "
    . "WHERE "
    . "    S.eventid = $eventid AND SR.responses IS NOT NULL AND SR.closed = 1 "
    . "GROUP BY     "
    . "    S.id, "
    . "    S.name_esp, S.name_eng, S.name_por, "
    . "    S.dsc_esp, S.dsc_eng, S.dsc_por";
    
    // Se concatena el order by 
    $sql= $sql.$strorderby;

    
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    

    $records = array();
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->id = $row["id"];
        $record->name = $row["name_".$outputlanguage];
        $record->dsc = $row["dsc_".$outputlanguage];
        $record->responses=$row["responses"];
        $records[] = $record;
    }

    $out= new stdClass;
    $out->totals=new stdClass;
    $out->totals->answered =$answered;
    $out->totals->users =$users;
    $out->totals->incompleted =$saved;
    $out->surveys=$records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>