<?php
// cms/api/menus/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    $sql="SELECT id, name_esp, name_eng, name_por, status, defaultlang, ".
        "DATE_FORMAT(datestart,'%Y-%m-%d') AS formattedstart, DATE_FORMAT(dateend,'%Y-%m-%d') AS formattedend FROM events ORDER BY datestart desc";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $events = array();

    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        if (!is_null($row["name_esp"]) && strlen(ltrim($row["name_esp"]))>0)
            $record->name=$row["name_esp"];  
        else if (!is_null($row["name_eng"]) && strlen(ltrim($row["name_eng"]))>0)
            $record->name=$row["name_eng"];
            else if (!is_null($row["name_por"]) && strlen(ltrim($row["name_por"]))>0)
                $record->name=$row["name_por"];
                else $record->name="";     
        $record->defaultlang=$row["defaultlang"];
        if ($row["status"]==1)
            $record->active = "true";
        else
            $record->active = "false";
        $record->datestart=$row["formattedstart"];
        $record->dateend=$row["formattedend"];            
        $events[] = $record;
    }

    function getMenu($db, $father=0){
        if ($father==0)
            $sql =  "SELECT id, dsc, content, lngdsc FROM cmsmenus WHERE father IS NULL ORDER BY id ";
        else
            $sql =  "SELECT id, dsc, content, lngdsc FROM cmsmenus WHERE father = " . $father . " ORDER BY id";
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    
        $records = array();
        
        while ($row = $rs->fetch_assoc()){
            $record = new stdClass;
            $record->id=(integer)$row["id"];
            $record->dsc=$row["dsc"];  
            $record->content = $row["content"];
            $record->lngdsc = nvl($row["lngdsc"],"");
            $record->submenu = getMenu($db, (integer)$row["id"]);  
            $records[] = $record;
        }
        
        return($records);
    }

    $out= new stdClass;
    $out->events =$events;
    $out->options = getMenu($db);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>