<?php

    include_once("./dbconn.php");
    include_once("./utils.php");

     //Buscar la zona horaria del evento
    $sql = "SELECT E.utc_zoneid, Z.name FROM events E INNER JOIN utc_zones Z ON Z.id = E.utc_zoneid WHERE status=1";   
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())    
        badEnd("400", array("msg"=>"No hay evento activo"));
    $zonename=$row["name"];

    // Buscar la hora del mensaje
    $sql = "SELECT E.id eventid, UE.appuserid appuserid,  "
    . "    D.platform,  D.token, M.date, M.id messageid, "
    . "    M.message_esp, M.message_eng, M.message_por, M.sent "
    . "FROM  messages M "
    . "    INNER JOIN events E ON E.id=M.eventid "
    . "    INNER JOIN appuserevent UE ON UE.eventid=E.id "
    . "    INNER JOIN appdeviceuser DU ON DU.appuserid=UE.appuserid "
    . "    INNER JOIN appdevices D ON D.id=DU.appdeviceid "
    . "WHERE E.status=1 AND D.platform=1 AND sent=0 AND DU.status=1 ";

    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $success=0;
    $failure=0;
    while ($row = $rs->fetch_assoc()) {
        $fecha_hora=explode(" ",$row["date"]);
        $fecha=$fecha_hora[0];
        $hora=$fecha_hora[1];
        $hms=explode(":",$hora);
        $strhora=" ".$hms[0]." hours ";
        $strmin=" ".$hms[1]. " minutes ";
        $strsec=" ".$hms[2]." seconds ";
        $time=strtotime($fecha.$strhora.$strmin.$strsec);
        $keyToken = $row["token"];
        $message = $row["message_esp"];
        
        if (time()>convertirHora($db,$zonename,$time) && $row["sent"]==0 ) {
            $message_status=send_notification($keyToken, $message);
            //echo "<br>".$message_status;
            if ($message_status) {
                $success++;
                $sql="UPDATE messages SET sent=1 WHERE id=".$row["messageid"];
                if (!$db->query($sql)) 
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));            
            }
            else
                $failure++;
        }
        
    }
    echo "<br>Mensajes enviados!<br>Exitosos: ".$success."<br>Fallosos: ".$failure;
 
?>