<?php
// cms/api/activities/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("eventid","order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    //Buscar lenguaje por defecto
    $sql="SELECT activelanguages, defaultlang FROM events WHERE id=".$_REQUEST["eventid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $defaultlang=$row["defaultlang"];
        //if (substr_count($row["activelanguages"],"esp")>0)
        //    $defaultlang="esp";
    }

    // query principal    
    $sql=   "SELECT A.id, A.name_esp, A.name_eng, A.name_por, A.dsc_esp, A.dsc_eng, A.dsc_por, ".
            "DATE_FORMAT(datefrom,'%d/%m/%Y %r') AS start, ".
            "DATE_FORMAT(dateto,'%d/%m/%Y %r') AS end, ".
            "TIMEDIFF(dateto, datefrom) AS duracion,".
            "FLOOR(HOUR(TIMEDIFF(dateto, datefrom)) / 24) AS days, ".
            "MOD(HOUR(TIMEDIFF(dateto,  datefrom )), 24) AS hours, ".
            "MINUTE(TIMEDIFF(dateto, datefrom )) AS minutes, ". 
            "SECOND(TIMEDIFF(dateto, datefrom )) AS seconds, ". 
            "S.id as siteid, S.name_esp AS sitename_esp, S.name_eng AS sitename_eng, S.name_por AS sitename_por ".
            "FROM activities A INNER JOIN sites S ON S.id=A.siteid ";

    // inicio sin filtros
    $where=false;        
    // filtro panelist
    if (isset($_REQUEST["panelistid"])){    
        $sql.= " INNER JOIN activitypanelists AP ON AP.activityid=A.id ".
                "AND AP.panelistid=".$_REQUEST["panelistid"];
    } 
    // filtro site
    if (isset($_REQUEST["siteid"])){ 
        if ($where)
            $sql.= " AND A.siteid=".$_REQUEST["siteid"]." ";
        else 
            $sql.= " WHERE A.siteid=".$_REQUEST["siteid"]." ";
        $where = true;    
    }
    // filtro date
    if (isset($_REQUEST["date"])){ 
        if ($where)
            $sql.= " AND DATE_FORMAT(A.datefrom,'%Y-%m-%d')='".$_REQUEST["date"]."'";
        else 
            $sql.= " WHERE DATE_FORMAT(A.datefrom,'%Y-%m-%d')='".$_REQUEST["date"]."'";
        $where = true;    
    } 
    // filtro tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= " A.tags LIKE '%" . $tags[$i] . "%'  ";
            $filtertag .= ") ";
        }
        if ($where)
            $sql.= " AND ".$filtertag;
        else
            $sql.= " WHERE ".$filtertag;
        $where=true;
    }
        
    // filtro por nombre
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= "A.name_esp LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "A.name_eng LIKE '%" . $filtro[$i] . "%' OR ";            
            $filter .= "A.name_por LIKE '%" . $filtro[$i] . "%' ";            
            $filter .= ") ";
        if ($where)
            $sql.= " AND ".$filter." ";
        else 
            $sql.= " WHERE ".$filter." ";
        $where = true;
        }
    }
    // incluir el eventid
    if ($where)
        $sql.= " AND A.eventid=".$_REQUEST["eventid"];
    else
        $sql.= " WHERE A.eventid=".$_REQUEST["eventid"];
        
    // contar numofrecords
    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }

    // order
    if (isset($_REQUEST["order"])) {
        if ($_REQUEST["order"]>0)
            $type=' ASC ';
        else $type=' DESC ';
        switch (abs($_REQUEST["order"])) {
            case 1:
                $strorderby=" ORDER BY A.name_esp ".$type;
                break;
            case 2:
                $strorderby=" ORDER BY A.datefrom ".$type;
                break; 
            case 3:
                $strorderby=" ORDER BY TIMEDIFF(A.dateto, A.datefrom) ".$type;
                break;
            case 4:
                $strorderby=" ORDER BY S.name_esp ".$type;
                break;                 
            default:
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
        }   
        $sql.= $strorderby;
    }      

    

    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrec"];
   
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    // Se llena la estructura
    $records = array();
    $languages = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        if (!is_null($row["name_".$defaultlang]) && trim($row["name_".$defaultlang])!="")
            $record->name=$row["name_".$defaultlang];
        elseif (!is_null($row["name_esp"]) && trim($row["name_esp"])!="")
            $record->name=$row["name_esp"];
        elseif (!is_null($row["name_eng"]) && trim($row["name_eng"])!="")
            $record->name=$row["name_eng"];
        elseif (!is_null($row["name_por"]) && trim($row["name_por"])!="")
            $record->name=$row["name_por"];
        else
            $record->name="";

        if (!is_null($row["dsc_".$defaultlang]) && trim($row["dsc_".$defaultlang])!="")
            $record->dsc=$row["dsc_".$defaultlang];
        elseif (!is_null($row["dsc_esp"]) && trim($row["dsc_esp"])!="")
            $record->dsc=$row["dsc_esp"];
        elseif (!is_null($row["dsc_eng"]) && trim($row["dsc_eng"])!="")
            $record->dsc=$row["dsc_eng"];
        elseif (!is_null($row["dsc_por"]) && trim($row["dsc_por"])!="")
            $record->dsc=$row["dsc_por"];
        else
            $record->dsc="";          
        $record->startat = $row["start"];
        switch ($row["days"]) {
            case 0:
                $day = "";
                $labelday="";
                break;
            case 1:
                $day="1";
                $labelday=" Día";
                break;
            default:
                $day=$row["days"];
                $labelday=" Días";
        }
        switch ($row["hours"]) {
            case 0:
                $hour="";
                $labelhour="";
                break;
            case 1:
                $hour="1";
                $labelhour=" Hora ";
                break;
            default:
                $hour=$row["hours"];
                $labelhour=" Hrs ";
        }        
        switch ($row["minutes"]) {
            case 0:
                $minute="";
                $labelmin="";
                break;
            case 1:
                $minute="1";
                $labelmin=" Min ";
                break;
            default:
                $minute=$row["minutes"];
                $labelmin=" Mins ";
        }        
        switch ($row["seconds"]) {
            case 0:
                $second="";
                $labelsec="";
                break;
            case 1:
                $second="1";
                $labelsec=" Seg";
                break;
            default:
                $second=$row["seconds"];
                $labelsec=" Segs";
        }        

        if ($day>0)
            $record->duration = $day.$labelday;
        elseif (0<$hour && $hour<24) 
            $record->duration = rtrim($hour.$labelhour.$minute.$labelmin);
            elseif (0<$minute && $minute<60) 
                $record->duration = rtrim($minute.$labelmin.$seconds.$labelsecond);
                elseif (0<$second && $second<60)
                    $record->duration = $second.$labelsec;
        $record->site=new stdClass;
        $record->site->id=$row["siteid"];
        
        if (!is_null($row["sitename_".$defaultlang]) && trim($row["sitename_".$defaultlang])!="")
            $record->site->name=$row["sitename_".$defaultlang];
        elseif (!is_null($row["sitename_esp"]) && trim($row["sitename_esp"])!="")
            $record->site->name=$row["sitename_esp"];
        elseif (!is_null($row["sitename_eng"]) && trim($row["sitename_eng"])!="")
            $record->site->name=$row["sitename_eng"];
        elseif (!is_null($row["sitename_por"]) && trim($row["sitename_por"])!="")
            $record->site->name=$row["sitename_por"];
        else
            $record->site->name="";

        //Se llenan los datos de los panelistas
        $sqlpanelistas="SELECT P.id, P.name, P.surname, CONCAT_WS(' ', P.name, P.surname) AS fullname, ".
                        "P.imagetype FROM activitypanelists AP ".
                        "INNER JOIN panelists P ON P.id = AP.panelistid ".
                        "WHERE AP.activityid =".$row["id"];
                        
        // Se ejecuta el query de panelistas
        if (!$rspanelistas=$db->query($sqlpanelistas))
            badEnd("500", array("sql"=>$sqlpanelistas,"msg"=>$db->error));
        $panelistas=array();
        while ($rowpanelista = $rspanelistas->fetch_assoc()){
            $panelista = new stdClass;
            $panelista->id=$rowpanelista["id"];
            $panelista->name=$rowpanelista["name"];
            $panelista->surname=$rowpanelista["surname"];
            $panelista->fullname=$rowpanelista["fullname"];
            if (is_null($rowpanelista["imagetype"]))
                $panelista->image="";
            else {    
                switch ($rowpanelista["imagetype"]){
                    case "image/png":
                        $ext = ".png";
                        break;                            
                    case "image/jpeg":
                    case "image/jpg":
                        $ext = ".jpg";
                        break;
                    default:
                        badEnd("400", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
                }        
                $panelista->image=$homeurl."uploads/panelists/".$rowpanelista["id"].$ext;
            }
            $panelistas[]=$panelista;
        }
            
        $record->panelists=$panelistas;
        unset($panelistas);
        $records[] = $record;
    }
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    $out->sql=$sqlpanelistas;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>