<?php
// cms/api/sites/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("eventid","order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);

    //Seleccionar idioma por defecto del evento.
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE id=".$_REQUEST["eventid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
        //if (substr_count($row["activelanguages"],"esp")>0)
        //    $defaultlang="esp";
    }
    
    // parametros opcionales
    //Se establece un filtro por el nombre
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= " name_esp LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= " name_eng LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= " name_por LIKE '%" . $filtro[$i] . "%' ";            
            $filter .= ") ";
        }
    }
    else $filter="";

    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= " sites.tags LIKE '%" . $tags[$i] . "%'  ";
            $filtertag .= ") ";
        }
    }
    else $filtertag="";

    // order
    // seleccionar el idioma del name para ordenar
    switch ($defaultlang) {
        case "esp":
            $name="name_esp";
            break;
        case "eng":
            $name="name_eng";
            break;
        case "por":
            $name="name_por";
            break;
    }    
    $strorderby="";
    if (isset($_REQUEST["order"])) {
        if ($_REQUEST["order"]>0)
            $type=' ASC ';
        else $type=' DESC ';
        switch (abs($_REQUEST["order"])) {
            case 1:
                $strorderby=" ORDER BY ".$name.$type;
                break;
            case 2:
                $strorderby=" ORDER BY datecreated ".$type;
                break;
            default:
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
        }   
    }    
    
    if (isset($_REQUEST["panelistid"]))
        $sql="SELECT sites.id, sites.name_esp, sites.name_eng, sites.name_por, sites.tags, sites.dsc_esp, sites.dsc_eng, sites.dsc_por ".
             " FROM sites INNER JOIN activities A ON A.siteid = sites.id INNER JOIN activitypanelists AP ON AP.activityid=A.id ".
             " WHERE sites.eventid=".$_REQUEST["eventid"]." AND AP.panelistid=".$_REQUEST["panelistid"];
    else
        $sql="SELECT sites.id, sites.name_esp, sites.name_eng, sites.name_por, sites.tags, sites.dsc_esp ".
            " FROM sites ".
            " WHERE sites.eventid=".$_REQUEST["eventid"];
    
    // Si hay filtro lo incluyo    
    if (strlen($filter)>0) 
        $sql= $sql." AND ".$filter." ";
    
    // Si hay filtro de tag lo incluyo    
    if (strlen($filtertag)>0) 
        $sql= $sql." AND (".$filtertag.") ";

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    
    // Se concatena el order by 
    $sql= $sql.$strorderby;
    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrec"];
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        
        if (!is_null($row["name_".$defaultlang]) && trim($row["name_".$defaultlang])!="")
            $record->name=$row["name_".$defaultlang];
        elseif (!is_null($row["name_esp"]) && trim($row["name_esp"])!="")
            $record->name=$row["name_esp"];
        elseif (!is_null($row["name_eng"]) && trim($row["name_eng"])!="")
            $record->name=$row["name_eng"];
        elseif (!is_null($row["name_por"]) && trim($row["name_por"])!="")
            $record->name=$row["name_por"];
        else
            $record->name="";
            
        $record->tags=nvl($row["tags"],"");            
        
        if (!is_null($row["dsc_".$defaultlang]) && trim($row["dsc_".$defaultlang])!="")
            $record->dsc=$row["dsc_".$defaultlang];
        elseif (!is_null($row["dsc_esp"]) && trim($row["dsc_esp"])!="")
            $record->dsc=$row["dsc_esp"];
        elseif (!is_null($row["dsc_eng"]) && trim($row["dsc_eng"])!="")
            $record->dsc=$row["dsc_eng"];
        elseif (!is_null($row["dsc_por"]) && trim($row["dsc_por"])!="")
            $record->dsc=$row["dsc_por"];
        else
            $record->dsc="";          

        //**Se buscan las actividades asociadas a ese site
        
        $sql2="SELECT A.id, name_esp, name_eng, name_por FROM activities A WHERE A.siteid=".$row["id"];
        if (!$rs2=$db->query($sql2))
            badEnd("500", array("sql"=>$sql2,"msg"=>$db->error));
        $arrayactivities=array();
        while ($row2 = $rs2->fetch_assoc()) {
            $activity = new stdClass;
            $activity->id=$row2["id"];
            
            if (!is_null($row2["name_".$defaultlang]) && trim($row2["name_".$defaultlang])!="")
                $activity->name=$row2["name_".$defaultlang];
            elseif (!is_null($row2["name_esp"]) && trim($row2["name_esp"])!="")
                $activity->name=$row2["name_esp"];
            elseif (!is_null($row2["name_eng"]) && trim($row2["name_eng"])!="")
                $activity->name=$row2["name_eng"];
            elseif (!is_null($row2["name_por"]) && trim($row2["name_por"])!="")
                $activity->name=$row2["name_por"];
            else
                $activity->name="";            
            
            $arrayactivities[]=$activity;
        }
        //**
        $record->activities=$arrayactivities;        

        $records[] = $record;
    }
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    $out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>