<?php
// app/api/reports/visitsdetails.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("contentid","eventid","order","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    $eventid=$_REQUEST["eventid"];
    $contentid=$_REQUEST["contentid"];
    
    //Validar sesion CMS
    isSessionValidCMS($db,$_REQUEST["sessionid"]);

    // order
    $strorderby= "";
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY contentname".$type;
            break;
        default:
            $strorderby = $type;
            if (abs($_REQUEST["order"]>99) || abs($_REQUEST["order"])<=10)
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
            //Escoger el día para ordenar
            $offset=abs($_REQUEST["order"])-11; 
            //Query para sacar el dia en fecha
            $sql = "SELECT DISTINCT(DATE_FORMAT(V.accesstime, '%Y-%m-%d')) AS date "
            . "FROM visitlog V where V.eventid = $eventid "
            . "ORDER BY accesstime "
            . "LIMIT 1 OFFSET $offset";
            if (!$rs=$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
            if ($row = $rs->fetch_assoc()) 
                $dayn=$row["date"];
            else
                badEnd("400", array("msg"=>"No hay registros para el día enviado"));
    }   
    
    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= "UPPER(tags) LIKE '%" . strtoupper($tags[$i]) . "%'  ";
            $filtertag .= ") ";
        }
        $filtertag =" AND ".$filtertag;
    }
    else $filtertag="";

    //Query para sacar el totalvalue por content
    $sql = "SELECT "
    . "    refid, COUNT(V.refid) AS total "
    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "     V.eventid= $eventid AND V.contenttype=$contentid AND V.refid<>0 "
    . "GROUP BY refid";               

    $totals = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $content=$row["refid"];
        $totals[$content]=$row["total"];
    }   
    
    $contentnames=contents_names($db,$eventid,$filtertag);    
    

    $sql = "SELECT "
    . "    refid, "
    . "    DATE_FORMAT(V.accesstime, '%Y-%m-%d') AS date, DATE_FORMAT(V.accesstime, '%d %b %y') AS formatted, "
    . "    COUNT(*) AS visits "
    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "    contenttype = $contentid AND refid <> 0 AND V.eventid=$eventid "
    . "GROUP BY "
    . "    refid, "
    . "    DATE_FORMAT(V.accesstime, '%Y-%m-%d')";                 

    $sqlp=$sql;
    $bar = array();
    $baractivity=array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));  
    $content='';
    while($row = $rs->fetch_assoc()) {
        if ($content=='') 
            $content=$row["refid"];
        if ($content == $row["refid"]){
            $record= new stdClass;
            $record->day = new stdClass;
            $record->day->date=$row["date"];
            $record->day->formatted = $row["formatted"];
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["visits"];
            $record->qty->formatted=number_format($row["visits"],0,",",".");
            $bar[] = $record;
            $content=$row["refid"];
        }
        else {
            $baractivity[$content]=$bar;
            unset($bar);
            $record= new stdClass;
            $record->day = new stdClass;
            $record->day->date=$row["date"];
            $record->day->formatted = $row["formatted"];
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["visits"];
            $record->qty->formatted=number_format($row["visits"],0,",",".");
            $bar[] = $record;
            $content=$row["refid"];
        }
    }
    $baractivity[$content]=$bar;


    switch($contentid) {
        case 1:
            $sqlselect = " A.name_esp AS contentname ";
            $table = " activities ";
            break;
        case 2:
            $sqlselect = " CONCAT_WS(' ',name,surname) AS contentname ";
            $table=" panelists ";
            break;
        case 3:
            $sqlselect=" A.name_esp AS contentname ";
            $table=" sites ";
            break;
        case 4:
            $sqlselect=" A.name_esp AS contentname ";
            $table=" surveys ";
            break;
        case 5:
            $sqlselect=" A.name AS contentname ";
            $table=" sponsors ";
            break;
    }

    if (abs($_REQUEST["order"])==1) {
        // Query principal orden por nombre
        $sql = "SELECT "
        . "    refid, ".$sqlselect
        . "FROM "
        . "    visitlog V INNER JOIN ".$table. " A ON V.refid=A.id "
        . "WHERE "
        . "     V.eventid= $eventid AND contenttype=$contentid AND refid<>0 "
        . "GROUP BY refid, contentname "
        . $strorderby;
    }
    else {
        
        // Query principal orden por día
        $sql =  "SELECT "
        . "    C.id AS refid, "
        . "    B.visits "
        . "FROM "
        . "    ( "
        . "    SELECT "
        . "        A.id, "
        . "        COUNT(V.refid) visits "
        . "    FROM "
        . "        ".$table." A "
        . "    LEFT JOIN visitlog V ON "
        . "        V.refid = A.id "
        . "    WHERE "
        . "        A.eventid = $eventid AND refid <> 0 AND DATE_FORMAT(V.accesstime, '%Y-%m-%d') ='$dayn' AND contenttype=$contentid "
        . "    GROUP BY "
        . "        A.id "
        . "    ORDER BY "
        . "        visits "
        . "    DESC "
        . ") B "
        . "RIGHT JOIN( "
        . "    SELECT "
        . "        A.id "
        . "    FROM "
        . "        ".$table." A "
        . "    WHERE "
        . "        A.eventid = $eventid "
        . ") C "
        . "ON "
        . "    C.id = B.id "
        . "ORDER BY "
        . "    B.visits ".$strorderby;
    } 
    $sql1=$sql;
    $contents = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        if (!is_null($contentnames[$contentid.$row["refid"]])) {
            $record= new stdClass;
            $record->content = new stdClass;
            $record->content->id = (integer)$row["refid"];
            $record->content->name = $contentnames[$contentid.$row["refid"]];
            $record->days=$baractivity[$row["refid"]];
            $record->totals = new stdClass;
            $record->totals->number = (integer)$totals[$row["refid"]];
            $record->totals->formatted = number_format($totals[$row["refid"]],2,",",".");
            $contents[] = $record;
        }
        
        
    }    
    $out= new stdClass;
    $out->contents= $contents;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>