<?php
// app/api/reports/visits.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("eventid","order","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    $eventid=$_REQUEST["eventid"];
    
    //Validar sesion CMS
    isSessionValidCMS($db,$_REQUEST["sessionid"]);

    // order
    $strorderby= "";
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY contentname".$type;
            break;
        default:
            $strorderby = $type;
            if (abs($_REQUEST["order"]>99) || abs($_REQUEST["order"])<=10)
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
            //Escoger el día para ordenar
            $offset=abs($_REQUEST["order"])-11; 
            //Query para sacar el dia en fecha
            $sql = "SELECT DISTINCT(DATE_FORMAT(V.accesstime, '%Y-%m-%d')) AS date "
            . "FROM visitlog V where V.eventid = $eventid "
            . "ORDER BY accesstime "
            . "LIMIT 1 OFFSET $offset";
            if (!$rs=$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
            if ($row = $rs->fetch_assoc()) 
                $dayn=$row["date"];
            else
                badEnd("400", array("msg"=>"No hay registros para el día enviado"));
    }  

    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= "UPPER(tags) LIKE '%" . strtoupper($tags[$i]) . "%'  ";
            $filtertag .= ") ";
        }
        $filtertag =" AND ".$filtertag;
    }
    else $filtertag="";


    //Query para sacar el totalvalue 
    
    $sql = "SELECT "
    . "    contenttype, "
    . "    COUNT(*) AS total "
    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "    refid <> 0 AND V.eventid = $eventid "
    . "GROUP BY "
    . "    contenttype";

    $totals = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $contenttype=$row["contenttype"].$row["refid"];
        $totals[$contenttype]=$row["total"];
    }
    
    //Query por content con visitas por día 
    $sql = "SELECT "
    . "    contenttype, "
    . "    DATE_FORMAT(V.accesstime, '%Y-%m-%d') AS date, DATE_FORMAT(V.accesstime, '%d %b %y') AS formatted, "
    . "    COUNT(*) AS visits "
    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "    refid <> 0 AND V.eventid=$eventid "
    . "GROUP BY "
    . "    contenttype, "
    . "    DATE_FORMAT(V.accesstime, '%Y-%m-%d'), DATE_FORMAT(V.accesstime, '%d %b %y')";      

    
    $bar = array();
    $barcontent=array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));  
    $content='';
    while($row = $rs->fetch_assoc()) {
        if ($content=='') 
            $content=$row["contenttype"];
        if ($content == $row["contenttype"]){
            $record= new stdClass;
            $record->day = new stdClass;
            $record->day->date=$row["date"];
            $record->day->formatted = $row["formatted"];
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["visits"];
            $record->qty->formatted=number_format($row["visits"],0,",",".");
            $bar[] = $record;
            $content=$row["contenttype"];
        }
        else {
            $barcontent[$content]=$bar;
            unset($bar);
            $record= new stdClass;
            $record->day = new stdClass;
            $record->day->date=$row["date"];
            $record->day->formatted = $row["formatted"];
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["visits"];
            $record->qty->formatted=number_format($row["visits"],0,",",".");
            $bar[] = $record;
            $content=$row["contenttype"];
        }
    }
    $barcontent[$content]=$bar;
    unset($bar);

    if (abs($_REQUEST["order"])==1) {
        // QUERY PRINCIPAL
        $sql = "SELECT contenttype,  "
        . "    (CASE WHEN  contenttype=1 THEN 'ACTIVIDADES' WHEN  contenttype=2 THEN 'PANELISTAS' "
        . "     WHEN  contenttype=3 THEN 'LUGARES' WHEN  contenttype=4 THEN 'ENCUESTAS' "
        . "     WHEN  contenttype=5 THEN 'PATROCINANTES' END) AS contentname "        

        . "FROM "
        . "    visitlog V "
        . "WHERE "
        . "    refid <> 0 AND V.eventid = $eventid "
        . "GROUP BY contenttype ".$strorderby;  
    }
    else {
        $sql =  "SELECT "
        . "    C.contenttype AS contenttype, "
        . "    (CASE WHEN C.contenttype=1 THEN 'ACTIVIDADES' WHEN C.contenttype=2 THEN 'PANELISTAS' "
        . "     WHEN C.contenttype=3 THEN 'LUGARES' WHEN C.contenttype=4 THEN 'ENCUESTAS' "
        . "     WHEN C.contenttype=5 THEN 'PATROCINANTES' END) AS contentname, "        
        . "    B.visits "
        . "FROM "
        . "    ( "
        . "    SELECT "
        . "        contenttype, "
        . "        COUNT(V.refid) visits "
        . "    FROM "
        . "     visitlog V  "
        . "    WHERE "
        . "        V.eventid = $eventid AND refid <> 0 AND DATE_FORMAT(V.accesstime, '%Y-%m-%d') ='$dayn' "
        . "    GROUP BY "
        . "        contenttype "
        . "    ORDER BY "
        . "        visits "
        . "    DESC "
        . ") B "
        . "RIGHT JOIN (SELECT DISTINCT contenttype FROM visitlog WHERE eventid= $eventid) C ON C.contenttype=B.contenttype "
        . "ORDER BY "
        . "    B.visits ".$strorderby;        
    }

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));  
    $contents=array();
    while($row = $rs->fetch_assoc()) {
        $content=$row["contenttype"];

            $record = new stdClass;
            $record->content = new stdClass;
            $record->content->id=(integer)$row["contenttype"];
            switch ($row["contenttype"]) {
                case 1:
                    $name='ACTIVIDADES';
                    break;
                case 2:
                    $name='PANELISTAS';
                    break;
                case 3:
                    $name='LUGARES';
                    break;
                case 4:
                    $name='ENCUESTAS';
                    break;
                case 5:
                    $name='PATROCINANTES';
                    break;
            }
            
            $record->content->name=$name;
            $record->days=$barcontent[$content];
            $record->totals = new stdClass;
            $record->totals->number = (integer)$totals[$content];
            $record->totals->formatted = number_format($totals[$content],2,",",".");
    
            $contents[]=$record;

    }

    // participation
    //Query para sacar el maxvalue por dia
    $sql = "SELECT A.date, SUM(A.uniquevisits +(CASE WHEN A.visitsnull > 0 THEN 1 ELSE 0 END)) AS visits "
    . "FROM "
    . "    (SELECT "
    . "        DATE_FORMAT(V.accesstime, '%Y-%m-%d') AS DATE, "
    . "        contenttype, "
    . "        COUNT(DISTINCT V.appuserid) AS uniquevisits, "
    . "        SUM(CASE WHEN V.appuserid IS NULL THEN 1 ELSE 0 END) AS visitsnull "
    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "    refid <> 0 AND eventid = $eventid "
    . "GROUP BY "
    . "    DATE_FORMAT(V.accesstime, '%Y-%m-%d'), "
    . "    contenttype) A "
    . "GROUP BY A.date";

    $sqlmax=$sql;
    $maxvalue = 0;
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        if ($row["visits"]>$maxvalue)
            $maxvalue=$row["visits"];
    }     

    $sql = "SELECT "
    . "    A.DATE AS date, "
    . "    A.contenttype AS contenttype, "
    . "    COUNT(A.appuserid) AS visits "
    . "FROM "
    . "    (SELECT "
    . "     DATE_FORMAT(V.accesstime, '%Y-%m-%d') AS DATE, "
    . "     contenttype, "
    . "     SUM(CASE WHEN V.appuserid IS NULL THEN 1 ELSE V.appuserid END) AS appuserid "
    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "    refid <> 0 AND eventid = $eventid "
    . "GROUP BY "
    . "    DATE_FORMAT(V.accesstime, '%Y-%m-%d'), "
    . "    contenttype,  "
    . "    V.appuserid "
    . ") A "
    . "GROUP BY A.date,    A.contenttype";    
    $sqlbar=$sql;
    $bar = array();
    $bardate=array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));  
    $fecha='';
    while($row = $rs->fetch_assoc()) {
        if ($fecha=='') 
            $fecha='date'.$row["date"];
        if ($fecha == 'date'.$row["date"]){
            $record= new stdClass;
            $record->content = new stdClass;
            $record->content->id=(integer)$row["contenttype"];
            switch ($row["contenttype"]) {
                case 1:
                    $name='ACTIVIDADES';
                    break;
                case 2:
                    $name='PANELISTAS';
                    break;
                case 3:
                    $name='LUGARES';
                    break;
                case 4:
                    $name='ENCUESTAS';
                    break;
                case 5:
                    $name='PATROCINANTES';
                    break;
            }            
            $record->content->name = $name;
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["visits"];
            $record->qty->formatted=number_format($row["visits"],0,",",".");
            $bar[] = $record;
            $fecha='date'.$row["date"];
        }
        else {
            $bardate[$fecha]=$bar;
            unset($bar);
            $record= new stdClass;
            $record->content = new stdClass;
            $record->content->id=(integer)$row["contenttype"];
            switch ($row["contenttype"]) {
                case 1:
                    $name='ACTIVIDADES';
                    break;
                case 2:
                    $name='PANELISTAS';
                    break;
                case 3:
                    $name='LUGARES';
                    break;
                case 4:
                    $name='ENCUESTAS';
                    break;
                case 5:
                    $name='PATROCINANTES';
                    break;
            }
            $record->content->name = $name;
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["visits"];
            $record->qty->formatted=number_format($row["visits"],0,",",".");
            $bar[] = $record;
            $fecha='date'.$row["date"];
        }
    }
    $bardate[$fecha]=$bar;
    unset($bar);
    

    $sql = "SELECT "
    . "    DATE_FORMAT(V.accesstime, '%d %b %y') AS formatted , DATE_FORMAT(V.accesstime, '%Y-%m-%d') AS date "

    . "FROM "
    . "    visitlog V "
    . "WHERE "
    . "    V.eventid = $eventid AND refid<>0 "
    . "GROUP BY "
    . "    DATE_FORMAT(V.accesstime, '%d %b %y'), DATE_FORMAT(V.accesstime, '%Y-%m-%d') ";
    
    $days = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->day = new stdClass;
        $record->day->date = $row["date"];
        $record->day->formatted = $row["formatted"];
        $record->bar=$bardate['date'.$row["date"]];
        $days[] = $record;
    }    
    // Fin participation

    $out= new stdClass;
    


    $out->contents= $contents;
    $out->participation = new stdClass;        
    $out->participation->maxval=new stdClass;
    $out->participation->maxval->number=(integer)$maxvalue;
    $out->participation->maxval->formatted=number_format($maxvalue,0,",",".");

    $out->participation->days= $days;
    
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>