<?php
// cms/api/panelists/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("eventid","order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    // parametros opcionales
    //Se establece un filtro por el nombre+apellido, nombre, apellido, compania
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= "UPPER(name) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(surname) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(company) LIKE '%" . strtoupper($filtro[$i]) . "%' ";                        
            $filter .= ") ";
        }
    }
    else $filter="";

    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= "UPPER(tags) LIKE '%" . strtoupper($tags[$i]) . "%'  ";
            $filtertag .= ") ";
        }
    }
    else $filtertag="";

    // order
    $strorderby="";
    if (isset($_REQUEST["order"])) {
        if ($_REQUEST["order"]>0)
            $type=' ASC ';
        else $type=' DESC ';
        switch (abs($_REQUEST["order"])) {
            case 1:
                $strorderby=" ORDER BY name".$type;
                break;
            case 2:
                $strorderby=" ORDER BY company".$type;
                break;
            case 3:
                $strorderby=" ORDER BY id".$type;
                break;
            case 4:
                $strorderby=" ORDER BY id".$type;
                break;
            default:
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
        }   
    }    
    

    if (isset($_REQUEST["activityid"])) 
        $sql="SELECT id, name, surname, imagetype, tags, company, position_esp, dsc_esp, ".
            "email, website, facebook, twitter, instagram, linkedin ".
            "FROM panelists P INNER JOIN activitypanelists AP ON AP.panelistid=P.id ".
            "WHERE eventid=".$_REQUEST["eventid"]." AND AP.activityid=".$_REQUEST["activityid"];
    else
        $sql="SELECT id, name, surname, imagetype, tags, company, position_esp, dsc_esp, ".
            " email, website, facebook, twitter, instagram, linkedin " .
            " FROM panelists ".
            " WHERE eventid=".$_REQUEST["eventid"];
    
      
    // Si hay filtro lo incluyo    
    if (strlen($filter)>0) 
        $sql= $sql." AND ".$filter." ";
    
    // Si hay filtro de tag lo incluyo    
    if (strlen($filtertag)>0) 
        $sql= $sql." AND ".$filtertag." ";

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    
    // Se concatena el order by 
    $sql= $sql.$strorderby;
    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrec"];
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name"],"");
        $record->surname=nvl($row["surname"],"");
        // Imagen
        if (!is_null($row["imagetype"])) {
            switch ($row["imagetype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array(id=>1,msg=>"El formato del documento debe ser PNG o JPG"));
            }
            $record->image="./uploads/panelists/".$row["id"].$ext;
        }
        else
            $record->image="";
        // Fin imagen        
        $record->tags=nvl($row["tags"],"");            
        $record->company=nvl($row["company"],"");
        $record->position=nvl($row["position_esp"],"");
        $record->dsc=nvl($row["dsc_esp"],"");
        $record->email=nvl($row["email"],"");
        $record->website=nvl($row["website"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");

        //**Se buscan las actividades asociadas a ese panelista
        $sql2="SELECT A.id, A.name_esp AS name FROM activities A INNER JOIN activitypanelists AP ON AP.activityid=A.id WHERE AP.panelistid=".$row["id"];
        if (!$rs2=$db->query($sql2))
            badEnd("500", array("sql"=>$sql2,"msg"=>$db->error));
        $arrayactivities=array();
        while ($row2 = $rs2->fetch_assoc()) {
            $activity = new stdClass;
            $activity->id=$row2["id"];
            $activity->name=$row2["name"];
            $arrayactivities[]=$activity;
        }
        //**
        $record->activities=$arrayactivities;
        $records[] = $record;
    }
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    //$out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>