<?php
// cms/api/events/buttonlist

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("eventid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);

    $sql="SELECT E.id eventid, B.id, contentid, C.dsc dsccontent,title_esp, title_eng, title_por, B.dsc_esp, B.dsc_eng, B.dsc_por, ".
        " E.activelanguages,  B.status, imgtype, onlogin, width, opt1, opt2, opt3, opt4, opt5, opt6, opt7, opt8, opt9, opt10 ".
        " FROM buttons B ".
        " INNER JOIN events E ON E.id = B.eventid".
        " INNER JOIN contents C ON C.id = B.contentid".
        " WHERE eventid=".$_REQUEST["eventid"]." ORDER BY B.order";
    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }

    $records=array();
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->content=new stdClass;
        $record->content->id = $row["contentid"];
        $record->content->dsc = $row["dsccontent"];
        $record->title=new stdClass;
        $record->title->esp=$row["title_esp"];
        $record->title->eng=$row["title_eng"];
        $record->title->por=$row["title_por"];
        $record->dsc=new stdClass;
        $record->dsc->esp=nvl($row["dsc_esp"],"");
        $record->dsc->eng=nvl($row["dsc_eng"],"");
        $record->dsc->por=nvl($row["dsc_por"],"");
        $languages=explode(",",$row["activelanguages"]);
        $languagearray=array();
        foreach ($languages as $value){
            $languageitem=new stdClass;
            switch ($value){
                case "esp":
                    $languageitem->id="esp";
                    $languageitem->name="Español";
                    $languagearray[]=$languageitem;
                    break;
                case "eng":
                    $languageitem->id="eng";
                    $languageitem->name="English";
                    $languagearray[]=$languageitem;
                    break;
                case "por":
                    $languageitem->id="por";
                    $languageitem->name="Portugués";
                    $languagearray[]=$languageitem;
                    break;
                default:
                    $languageitem->id="";
                    $languageitem->name="";
                    $languagearray[]=$languageitem;
            }
        } 
        $record->languages=$languagearray;
        $record->status=new stdClass;
        if ($row["status"]==1){
            $record->status->id=$row["status"];
            $record->status->dsc="Activo";
        }
        else {
            $record->status->id=$row["status"];
            $record->status->dsc="Inactivo";
        }
        // Imagen
        if (!is_null($row["imgtype"])) {
            switch ($row["imgtype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array(id=>1,msg=>"El formato del documento debe ser PNG o JPG"));
            }
            $record->url="./uploads/buttons/".$row["id"].$ext;
        }
        else
            $record->url="";
        // Fin imagen
        if ($row["onlogin"]==1)
            $record->onlogin=true;
        else 
            $record->onlogin=false;
        
        $record->width=$row["width"];
        
        $options=array(nvl($row["opt1"],""),nvl($row["opt2"],""),nvl($row["opt3"],""),nvl($row["opt4"],""),nvl($row["opt5"],""),
                       nvl($row["opt6"],""),nvl($row["opt7"],""),nvl($row["opt8"],""),nvl($row["opt9"],""),nvl($row["opt10"],""));
        $record->options=$options;
        $records[]=$record;
    }
    
    $out= new stdClass;

    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    $out->security=new stdClass;
    $out->security->insert=true;
    $out->security->update=true;
    $out->security->delete=true;
    $out->security->read=true;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>