<?php
// cms/api/activities/entry

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    $sql="SELECT E.id, E.activelanguages, E.defaultlang ".
        " FROM events E INNER JOIN activities A ON A.eventid=E.id WHERE A.id=".$_REQUEST["id"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
        //if (substr_count($row["activelanguages"],"esp")>0)
        //    $defaultlang="esp";
    }

    // query principal    
    $sql=   "SELECT A.id, A.name_esp, A.name_eng, A.name_por, A.dsc_esp, A.dsc_eng, A.dsc_por, A.tags, ".
            "A.dsc_esp, A.dsc_eng, A.dsc_por, A.tags, ".
            "DATE_FORMAT(datefrom,'%d/%m/%Y %T') AS datefrom1, ".
            "DATE_FORMAT(datefrom,'%d/%m/%Y %r') AS datefrom2, ".
            "DATE_FORMAT(dateto,'%d/%m/%Y %T') AS dateto1, ".
            "DATE_FORMAT(dateto,'%d/%m/%Y %r') AS dateto2, ".
            "FLOOR(HOUR(TIMEDIFF(dateto, datefrom)) / 24) AS days, ".
            "MOD(HOUR(TIMEDIFF(dateto,  datefrom )), 24) AS hours, ".
            "MINUTE(TIMEDIFF(dateto, datefrom )) AS minutes, ". 
            "SECOND(TIMEDIFF(dateto, datefrom )) AS seconds, ". 
            "S.id as siteid, S.name_esp as sitename ".
            "FROM activities A INNER JOIN sites S ON S.id=A.siteid ".
            "WHERE A.id=".$_REQUEST["id"];

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sqlp"=>$sql,"msg"=>$db->error));

    //** query para obtener los panelistas
    $sqlp=   "SELECT P.id, CONCAT_WS(' ',P.name,P.surname) AS fullname FROM activitypanelists AP ".
            "   INNER JOIN panelists P ON P.id=AP.panelistid ".
            "   WHERE  AP.activityid=".$_REQUEST["id"];
    $arraypanelists=array();
    if (!$rsp=$db->query($sqlp))
        badEnd("500", array("sql"=>$sqlp,"msg"=>$db->error));
    while ($rowp = $rsp->fetch_assoc()){
        $estructura= new stdClass;
        $estructura->id=$rowp["id"];
        $estructura->name=$rowp["fullname"];
        $arraypanelists[]=$estructura;
    }
    //**
    
    // query para obtener los attachments
    $sqla=  "SELECT id, type, name, mimetype ".
            "FROM activityattachments AA ".
            "WHERE AA.activityid=".$_REQUEST["id"];    
    $arrayattachments=array();
    if (!$rsa=$db->query($sqla))
        badEnd("500", array("sql"=>$sqla,"msg"=>$db->error));
    while ($rowa = $rsa->fetch_assoc()){
        $attach= new stdClass;
        $attach->id=$rowa["id"];
        $attach->type=$rowa["type"];
        $attach->name=$rowa["name"];        
        if ($rowa["type"]==2)
            $attach->file=array();
        else {
            $attach->file=new stdClass;
            $attach->file->type=$rowa["mimetype"];
            $ext=".".substr($rowa["mimetype"],strrpos($rowa["mimetype"],"/")+1);
            if ($ext==".jpeg")
                $ext=".jpg";
            $filename=$rowa["id"].$ext;
            $attach->file->url=$homeurl."uploads/activities/".$_REQUEST["id"]."/".$filename;
        }
        $arrayattachments[]=$attach;
    }
    // Se llena la estructura
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=new stdClass;
        $record->name->esp=nvl($row["name_esp"],"");
        $record->name->eng=nvl($row["name_eng"],"");
        $record->name->por=nvl($row["name_por"],"");
        $record->site=new stdClass;
        $record->site->id=$row["siteid"];
        $record->site->name=$row["sitename"];
        $record->from = new stdClass;
        $record->from->date=$row["datefrom1"];
        $record->from->formatted=$row["datefrom2"];
        $record->to = new stdClass;
        $record->to->date=$row["dateto1"];
        $record->to->formatted=$row["dateto2"];      
        $record->tags=$row["tags"];
        $record->dsc=new stdClass;
        $arraylang = array("esp"=>nvl($row["dsc_esp"],""), "eng"=>nvl($row["dsc_eng"],""), "por"=>nvl($row["dsc_por"],""));
        $record->dsc=$arraylang;
        $record->panelists=$arraypanelists;
        $record->attachments=$arrayattachments;
    }

    $out= new stdClass;
    $out->entry =$record;
    //$out->sqla=$sqla;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>