<?php
// app/api/activities/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("order","offset","numofrecords");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
        
    //Seleccionar idioma por defecto del evento. Si el español está entre los disponibles, se toma esp por defecto
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE status=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
        if (substr_count($row["activelanguages"],"esp")>0)
            $defaultlang="esp";
    }

    //Si el usuario es logueado buscar el idioma favorito y hacerlo el idioma por defecto en la app
    $favoritelang="";
    if (isset($_REQUEST["sessionid"])){
        $userid=isSessionValid($db,$_REQUEST["sessionid"]);
        $sql="SELECT favoritelanguage ".
            " FROM appusers WHERE id=".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc()) 
            $favoritelang=$row["favoritelanguage"];
    }
    // Si est¨¢ logueado buscar si el idioma favorito est¨¢ entre los idiomas disponibles del evento
    //sino est¨¢, se deja el idioma por defecto del evento
    $foundmylanguage=false;
    if (isset($_REQUEST["sessionid"])) 
        foreach ($language as $valor) 
            if ($valor==$favoritelang) {
                $foundmylanguage=true;                    
                break;
            }
    if ($foundmylanguage) 
        $defaultlang=$favoritelang;

    // Se marca la visita en visitlog
    $contenttype=1; //CONTENTTYPE 1=actividad, 2=panelista, 3=lugar, 4=encuesta, 5=Patrocinantes
    $refid=0; // REFID 0 cuando es acceso al listado
    if (isset($_REQUEST["sessionid"])){
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);    
        $sql="INSERT INTO visitlog (id, contenttype, refid, appuserid, eventid) VALUES ("
        . " 0, $contenttype, $refid, $appuserid, $eventid )";
        if (!$db->query($sql))
    	    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    else {
        $sql="INSERT INTO visitlog (id, contenttype, refid, eventid) VALUES ("
        . " 0, $contenttype, $refid, $eventid )";
        if (!$db->query($sql))
    	    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    // query principal    
    $sql=   "SELECT A.id, A.name_esp, A.name_eng, A.name_por, A.dsc_esp, A.dsc_eng, A.dsc_por, ".
            "DATE_FORMAT(datefrom,'%Y-%m-%d') AS date, ".
            "DATE_FORMAT(datefrom,'%d %M, %Y') AS formatted, ".            
            "DATE_FORMAT(datefrom,'%h:%i %p') AS start, ".            
            "DATE_FORMAT(dateto,'%h:%i %p') AS end, ".
            "TIMEDIFF(dateto, datefrom) AS duracion,".
            "FLOOR(HOUR(TIMEDIFF(dateto, datefrom)) / 24) AS days, ".
            "MOD(HOUR(TIMEDIFF(dateto,  datefrom )), 24) AS hours, ".
            "MINUTE(TIMEDIFF(dateto, datefrom )) AS minutes, ". 
            "SECOND(TIMEDIFF(dateto, datefrom )) AS seconds, ". 
            "S.id as siteid, S.name_esp AS sitename_esp, S.name_eng AS sitename_eng, S.name_por AS sitename_por ".
            "FROM activities A INNER JOIN sites S ON S.id=A.siteid ";


    // filtro tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= " A.tags LIKE '%" . $tags[$i] . "%'  ";
            $filtertag .= ") ";
        }
        if ($where)
            $sql.= " AND ".$filtertag;
        else
            $sql.= " WHERE ".$filtertag;
        $where=true;
    }
        
    // filtro por nombre
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= "A.name_esp LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "A.name_eng LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "A.name_por LIKE '%" . $filtro[$i] . "%' ";                        
            $filter .= ") ";
        if ($where)
            $sql.= " AND ".$filter." ";
        else 
            $sql.= " WHERE ".$filter." ";
        $where = true;
        }
    }
    // incluir el eventid
    if ($where)
        $sql.= " AND A.eventid=".$eventid;
    else
        $sql.= " WHERE A.eventid=".$eventid;
        
    // contar numofrecords
    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }

    // order
    $type=' ASC ';
    switch ($_REQUEST["order"]) {
        case 1:
            $strorderby=" ORDER BY S.name_".$defaultlang." ".$type.", A.datefrom ";
            break;
        case 0:
            $strorderby=" ORDER BY A.datefrom ".$type;
            break; 
        default:
            badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
    }   
    $sql.= $strorderby;

    //Set local para idioma del mes
    $sqlset="SET lc_time_names = 'es_ES'";     
    if (!$db->query($sqlset)) 
        badEnd("500", array("sql"=>$sqlset,"msg"=>$db->error));

    
    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrecords"];
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $records=array();
    // Se llena la estructura cuando order es 0
    if ($_REQUEST["order"]==0) {
        $group=0;
        $arrayactivities=array();
        while ($row=$rs->fetch_assoc()){
            if ($group==$row["date"]){
                $activity=new stdClass;
                $activity->id=(integer)$row["id"];
                $activity->name=nvl($row["name_".$defaultlang],"");
                $activity->dsc=nvl($row["dsc_".$defaultlang],"");
                $activity->timefrom=nvl($row["start"],"");
                $activity->timeto=nvl($row["end"],"");
                $activity->site=new stdClass;
                $activity->site->id=(integer)$row["siteid"];
                $activity->site->name=$row["sitename_".$defaultlang];
                $arrayactivities[]=$activity;
                $group=$row["date"];
                continue;
            }
            elseif ($group<>0) {
                $record->activities=$arrayactivities;
                unset($arrayactivities);
                $records[]=$record;
                $record=new stdClass;
                $record->day=new stdClass;
                $record->day->date=$row["date"];
                $record->day->formatted=$row["formatted"];
                $activity=new stdClass;
                $activity->id=(integer)$row["id"];
                $activity->name=nvl($row["name_".$defaultlang],"");
                $activity->dsc=nvl($row["dsc_".$defaultlang],"");
                $activity->timefrom=nvl($row["start"],"");
                $activity->timeto=nvl($row["end"],"");
                $activity->site=new stdClass;
                $activity->site->id=(integer)$row["siteid"];
                $activity->site->name=$row["sitename_".$defaultlang];
                $arrayactivities[]=$activity;
                $group=$row["date"];
            }
            else{
                $record=new stdClass;
                $record->day=new stdClass;
                $record->day->date=$row["date"];
                $record->day->formatted=$row["formatted"];
                $activity=new stdClass;
                $activity->id=(integer)$row["id"];
                $activity->name=nvl($row["name_".$defaultlang],"");
                $activity->dsc=nvl($row["dsc_".$defaultlang],"");
                $activity->timefrom=nvl($row["start"],"");
                $activity->timeto=nvl($row["end"],"");
                $activity->site= new stdClass;
                $activity->site->id=(integer)$row["siteid"];
                $activity->site->name=$row["sitename_".$defaultlang];
                $arrayactivities[]=$activity;
                $group=$row["date"];
            }
        }
        if ($group<>0){
            $record->activities=$arrayactivities;
            $records[]=$record;            
        }
    }
    // Se llena la estructura cuando order es 1
    if ($_REQUEST["order"]==1) {
        $group=0;
        $arrayactivities=array();
        while ($row=$rs->fetch_assoc()){
            if ($group==$row["siteid"]){
                $activity=new stdClass;
                $activity->id=(integer)$row["id"];
                $activity->name=nvl($row["name_".$defaultlang],"");
                $activity->dsc=nvl($row["dsc_".$defaultlang],"");
                $activity->timefrom=nvl($row["start"],"");
                $activity->timeto=nvl($row["end"],"");
                $activity->day=new stdClass;
                $activity->day->date=$row["date"];
                $activity->day->formatted=$row["formatted"];
                $arrayactivities[]=$activity;
                $group=$row["siteid"];
                continue;
            }
            elseif ($group<>0) {
                $record->activities=$arrayactivities;
                unset($arrayactivities);
                $records[]=$record;
                $record=new stdClass;
                $record->site=new stdClass;
                $record->site->id=$row["siteid"];
                $record->site->name=$row["sitename_".$defaultlang];
                $activity=new stdClass;
                $activity->id=(integer)$row["id"];
                $activity->name=nvl($row["name_".$defaultlang],"");
                $activity->dsc=nvl($row["dsc_".$defaultlang],"");
                $activity->timefrom=nvl($row["start"],"");
                $activity->timeto=nvl($row["end"],"");
                $activity->day=new stdClass;
                $activity->day->date=$row["date"];
                $activity->day->formatted=$row["formatted"];
                $arrayactivities[]=$activity;
                $group=$row["siteid"];
            }
            else{
                $record=new stdClass;
                $record->site=new stdClass;
                $record->site->id=$row["siteid"];
                $record->site->name=$row["sitename_".$defaultlang];
                $activity=new stdClass;
                $activity->id=(integer)$row["id"];
                $activity->name=nvl($row["name_".$defaultlang],"");
                $activity->dsc=nvl($row["dsc_".$defaultlang],"");
                $activity->timefrom=nvl($row["start"],"");
                $activity->timeto=nvl($row["end"],"");
                $activity->day=new stdClass;
                $activity->day->date=$row["date"];
                $activity->day->formatted=$row["formatted"];
                $arrayactivities[]=$activity;
                $group=$row["siteid"];
            }
        }
        if ($group<>0){
            $record->activities=$arrayactivities;
            $records[]=$record;            
        }
        
    }    
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>