<?php
// app/api/surveys/entry.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Seleccionar idioma por defecto del evento y los idiomas disponibles 
    $sql="SELECT E.id, activelanguages, defaultlang ".
        "FROM events E ".
        "INNER JOIN surveys S ON S.eventid=E.id ".
        "WHERE E.status=1 ".
        "AND S.id = ".$_REQUEST["id"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
    }
    else
        badEnd("400", array("msg"=>"La encuesta no pertenece al evento activo"));
    //Si el usuario es logueado buscar el idioma favorito
    $favoritelang="";
    if (isset($_REQUEST["sessionid"])){
        $userid=isSessionValid($db,$_REQUEST["sessionid"]);
        $sql="SELECT favoritelanguage ".
            " FROM appusers WHERE id=".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc()) 
            $favoritelang=$row["favoritelanguage"];
        // Buscar si el idioma favorito est¨¢ entre los idiomas disponibles del evento
        //sino est¨¢, se deja el idioma por defecto del evento
        $foundmylanguage=false;
        foreach ($language as $valor) 
            if ($valor==$favoritelang) {
                $foundmylanguage=true;                    
                break;
            }
        if ($foundmylanguage) 
            $defaultlang=$favoritelang;            
    }
    $outputlang=$defaultlang;

    $sql = "SELECT "
        . "    S.id AS surveyid, "
        . "    S.name_esp, "
        . "    S.name_eng, "
        . "    S.name_por, "
        . "    S.dsc_esp AS surveydsc_esp, "
        . "    S.dsc_eng AS surveydsc_eng, "
        . "    S.dsc_por AS surveydsc_por, "
        . "    S.status AS surveystatus, "
        . "    SQ.id AS questionid, "
        . "    SQ.type, "
        . "    SQ.dsc_esp AS qdsc_esp, "
        . "    SQ.dsc_eng AS qdsc_eng, "
        . "    SQ.dsc_por AS qdsc_por, "
        . "    SQ.status AS questionstatus, "
        . "    SO.id AS optionid, "
        . "    option_esp, "
        . "    option_eng, "
        . "    option_por, "
        . "    R.closed, "
        . "    R.responses "
        . "FROM surveys S "
        . "INNER JOIN surveyquestions SQ ON "
        . "    SQ.surveyid = S.id "
        . "INNER JOIN surveyoptions SO ON "
        . "    SO.questionid = SQ.id "
        . "LEFT JOIN "
        . "	(SELECT SR.appuserid, SR.closed, SR.responses, SR.surveyquestionid "
        . "		FROM surveyresponses SR INNER JOIN surveyquestions SQ ON SQ.id=SR.surveyquestionid "
        . "		WHERE appuserid=".$userid." AND SQ.surveyid=".$_REQUEST["id"].") R   "
        . "     ON R.surveyquestionid = SQ.id "
        . "WHERE "
        . "    S.id =".$_REQUEST["id"]. " ";  

    // Se ejecuta el query principal

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $surveyact="";
    while ($row = $rs->fetch_assoc()){
        if ($surveyact<>$row["surveyid"]){
            if ($surveyact<>"") {
                $survey->questions[]=$question;
            }
            $survey=new stdClass;
            $survey->id=(integer)$row["surveyid"];
            $survey->name= new stdClass;
            $surveynames=array('esp'=>nvl($row["name_esp"],""),'eng'=>nvl($row["name_eng"],""),'por'=>nvl($row["name_por"],""));
            $survey->name=nvl($row["name_".$outputlang],"");
            
            $survey->dsc=nvl($row["surveydsc_".$outputlang],"");
            
            
            $survey->status= new stdClass;
            if ($row["surveystatus"]==1) {
                $survey->status->id=1;
                $survey->status->dsc="Activo";
            }
            else {
                $survey->status->id=0;
                $survey->status->dsc="Inactivo";
            }
            $survey->questions=array();
            $questionact="";
            $surveyact=$row["surveyid"];
        }
        if ($questionact <> $row["questionid"]) {
            if ($questionact<>"") {
                $survey->questions[]=$question;
            }
            $question=new stdClass;
            $question->id=(integer)$row["questionid"];
            $question->type=(integer)$row["type"];
            
            //$question->dsc=nvl($row["qdsc_".$outputlang],"");


            if (!is_null($row["qdsc_".$outputlanguage]) && trim($row["qdsc_".$outputlanguage])!="")
                 $question->dsc=$row["qdsc_".$outputlang];
            elseif (!is_null($row["qdsc_esp"]) && trim($row["qdsc_esp"])!="")
                 $question->dsc=$row["qdsc_esp"];
            elseif (!is_null($row["qdsc_eng"]) && trim($row["qdsc_eng"])!="")
                $question->dsc=$row["qdsc_eng"];
            elseif (!is_null($row["qdsc_por"]) && trim($row["qdsc_por"])!="")
                $question->dsc=$row["qdsc_por"];
            else
                $question->dsc="";            
            
            
            
            
            $question->status= new stdClass;
            if ($row["questionstatus"]==1) {
                $question->status->id=1;
                $question->status->dsc="Activo";
            }
            else {
                $question->status->id=0;
                $question->status->dsc="Inactivo";
            }
            $question->options=array();
            if ($row["closed"]==1)
                $question->closed=true;
            else
                $question->closed=false;
            $question->responses=nvl($row["responses"],"");            
            $questionact=$row["questionid"];
        }

        $option=new stdClass;
        $option->id=(integer)$row["optionid"];
        
        
        //$option->dsc=nvl($row["option_".$outputlang],"");
        
        if (!is_null($row["option_".$outputlanguage]) && trim($row["option_".$outputlanguage])!="")
             $option->dsc=$row["option_".$outputlang];
        elseif (!is_null($row["option_esp"]) && trim($row["option_esp"])!="")
             $option->dsc=$row["option_esp"];
        elseif (!is_null($row["option_eng"]) && trim($row["option_eng"])!="")
            $option->dsc=$row["option_eng"];
        elseif (!is_null($row["option_por"]) && trim($row["option_por"])!="")
            $option->dsc=$row["option_por"];
        else
            $option->dsc="";             
        
        
        
        if ($row["optionid"]<>0)
            $question->options[]=$option;
        else 
            $survey->questions=array();
    }
    if ($surveyact<>"") {
        $survey->questions[]=$question;
        if (is_null($question))
            $survey->questions=array();
    }

    
    $out= new stdClass;
    $out->entry =$survey;
    //$out->sql=$sqloutput;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();

?>