<?php
// app/api/sponsors/entry.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("sponsorid",);
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    //Seleccionar idioma por defecto del evento y los idiomas disponibles 
    $sql="SELECT E.id, activelanguages, defaultlang ".
        "FROM events E ".
        "INNER JOIN sponsors S ON S.eventid=E.id ".
        "WHERE E.status=1 ".
        "AND S.id = ".$_REQUEST["sponsorid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
    }
    else
        badEnd("400", array("msg"=>"El patrocinante no pertenece al evento activo"));
    //Si el usuario es logueado buscar el idioma favorito
    $favoritelang="";
    if (isset($_REQUEST["sessionid"])){
        $userid=isSessionValid($db,$_REQUEST["sessionid"]);
        $sql="SELECT favoritelanguage ".
            " FROM appusers WHERE id=".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc()) 
            $favoritelang=$row["favoritelanguage"];
        // Buscar si el idioma favorito est¨¢ entre los idiomas disponibles del evento
        //sino est¨¢, se deja el idioma por defecto del evento
        $foundmylanguage=false;
        foreach ($language as $valor) 
            if ($valor==$favoritelang) {
                $foundmylanguage=true;                    
                break;
            }
        if ($foundmylanguage) 
            $defaultlang=$favoritelang;            
    }

    $outputlanguage=$defaultlang;
    
    $sql="SELECT id, name, weight, imagetype, tags, dsc_esp, dsc_eng, dsc_por, email, website, ".
        "facebook, twitter, instagram, linkedin ".
        "FROM sponsors ".
        "WHERE id =".$_REQUEST["sponsorid"];

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name"],"");
        $record->weight=nvl($row["name"],"");
        // Imagen
        if (!is_null($row["imagetype"]) && $row["imagetype"]!=="") {
            switch ($row["imagetype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
            }
            $record->image=$homeurl."../cms/uploads/sponsors/".$row["id"].$ext;
        }
        else
            $record->image="";
        // Fin imagen        
        $record->tags=nvl($row["tags"],"");            
        $record->dsc=$row["dsc_".$outputlanguage];
        $record->email=nvl($row["email"],"");
        $record->website=nvl($row["website"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
    }
    
    $out= new stdClass;
    $out->records =$record;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>