<?php
// app/api/sites/entry.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("siteid","screenwidth","screenheight");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Seleccionar el evento activo y los idiomas disponibles
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE status=1";
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No hay evento activo disponible"));
    $eventid=$rowevent["id"];
    $languages=explode(",",$rowevent["activelanguages"]);

    $onlogin=0;
    $outputlanguage = $rowevent["defaultlang"];
    // Caso donde el usuario es logueado
    if (isset($_REQUEST["sessionid"])){
        //Obtener el id del usuario logueado
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);
        $onlogincondition="";
        // Seleccionar el idioma favorito del usuario logueado
        $sql="SELECT favoritelanguage FROM appusers WHERE id=".$appuserid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $row = $rs->fetch_assoc();
        $favoritelanguage=$row["favoritelanguage"];
        // Revisar si el idioma favorito esta dentro de los disponibles, si no esta devolver el idioma por defecto del evento
        foreach ($languages as $value){
            if ($value==$favoritelanguage)
                $outputlanguage=$value;
        }
    }
    else
       $onlogincondition=" AND onlogin=0 " ;
    
    // activityid NO DEFINIDO
    //if (isset($_REQUEST["activityid"]))

    // query principal
    $sql="SELECT id, name_".$outputlanguage." AS name, tags, dsc_esp, dsc_eng, dsc_por, coords ".
        " FROM sites ".
        " WHERE id=".$_REQUEST["siteid"]." AND sites.eventid=".$eventid;

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    //** Se llena arreglo de actividades
    $sqlact="SELECT A.siteid, A.id activityid, A.name_".$outputlanguage." AS name, A.name_esp, A.name_eng, A.name_por, ".
            " DATE_FORMAT(A.datefrom,'%Y-%m-%d %H:%i') AS datefrom1, DATE_FORMAT(A.datefrom,'%Y-%m-%d %h:%i%p') AS datefrom2, ".
            " DATE_FORMAT(datefrom,'%d/%m/%Y') AS dateformattedfrom, ".
            " DATE_FORMAT(dateto,'%d/%m/%Y') AS dateformattedto, ".
            " DATE_FORMAT(datefrom,'%h:%i %p') AS start, ".            
            " DATE_FORMAT(dateto,'%h:%i %p') AS end, ".
            " DATE_FORMAT(A.dateto,'%Y-%m-%d %H:%i') AS dateto1, DATE_FORMAT(A.dateto,'%Y-%m-%d %h:%i%p') AS dateto2, A.tags ".            
            " FROM activities A  WHERE A.siteid=".$_REQUEST["siteid"];
       
    if (!$rsact=$db->query($sqlact))
        badEnd("500", array("sql"=>$sqlact,"msg"=>$db->error));

    $activities = array();
    $siteid=0;
    while ($rowact = $rsact->fetch_assoc()){
        if ($siteid==0)
            $siteid=$rowact["siteid"];
        $estructura = new stdClass;
        $estructura->id=(integer)$rowact["activityid"];
        switch ($outputlanguage) {
            case "esp":
                $name=nvl($rowact["name_esp"],"");
                break;
            case "eng":
                $name=nvl($rowact["name_eng"],"");
                break;
            case "por":
                $name=nvl($rowact["name_por"],"");
                break;
            default:
                $name="";
        }

        $estructura->name=$rowact["name"];
        $estructura->from = new stdClass;
        $estructura->from->date=$rowact["dateformattedfrom"];
        $estructura->from->formatted=$rowact["datefrom2"];
        $estructura->from->timefrom=$rowact["start"];
        $estructura->to = new stdClass;
        $estructura->to->date=$rowact["dateformattedto"];
        $estructura->to->formatted=$rowact["dateto2"];
        $estructura->to->timeto=$rowact["end"];
        $estructura->tags=$rowact["tags"];
        
        //** Se llena arreglo de actividades $rowact["activityid"]
        $sqlpan="SELECT P.id, CONCAT_WS(' ',P.name, P.surname) AS fullname ".
        "FROM panelists P INNER JOIN activitypanelists AP ON AP.panelistid=P.id ".
        "WHERE AP.activityid=".$rowact["activityid"];
       
        if (!$rspan=$db->query($sqlpan))
            badEnd("500", array("sql"=>$sqlpan,"msg"=>$db->error));
        $panelists=array();
        while ($rowpan = $rspan->fetch_assoc()) {
            $panelist = new stdClass;
            $panelist->id=(integer)$rowpan["id"];
            $panelist->fullname=$rowpan["fullname"];
            $panelists[]=$panelist;
        }
        //**
        $estructura->panelists=$panelists;

        $activities[]=$estructura;
    }
    //**    
    
    $records = array();
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        switch ($outputlanguage){
            case "esp":
                $dsc = nvl($row["dsc_esp"],"");
                break;
            case "eng":
                $dsc = nvl($row["dsc_eng"],"");
                break;
            case "por":
                $dsc = nvl($row["dsc_por"],"");
                break;
            default:
                $dsc = "";
                break;                
        }  
        $entry=new stdClass;
        $entry->id=(integer)$row["id"];        
        $entry->name=nvl($row["name"],"");
        $entry->coords=nvl($row["coords"],"");
        $entry->tags=nvl($row["tags"],"");            
        $entry->dsc=$dsc;
        //------ Inicio obtener datos de imagenes
        $images=array();
        $dir='../../../cms/uploads/sites/'.$row["id"];
        //Si existe el directorio del site para las imagenes, busco un listado de las imagenes del directorio
        if (file_exists($dir)) {
            $a = scandir($dir);
            //Lleno el arreglo de estructura con datos de los archivos
            for($i=2; $i<count($a); $i++) {
                $imageobj= new stdClass;
                $imageobj->id=(integer)substr($a[$i], 0, strpos($a[$i], '.'));
                $ext=substr($a[$i],-3);
                $imageobj->type="image/".$ext;

                $url=$homeurl."../cms";
                $imageobj->url= $url."/api/getimage.php?filename="."../uploads/sites/".$row["id"]."/".$imageobj->id.".".$ext."&scrw=".$_REQUEST["screenwidth"]."&scrh=".$_REQUEST["screenheight"];                                
                $images[]=$imageobj;
            }
        }
        //------ Fin datos de imagenes         
        $entry->images=$images;
        $entry->activities=$activities;
    }
    $out = new stdClass;
    $out->site=$entry;
    //$out->sql =$sql;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>