<?php
// app/api/activities/entry

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("activityid","screenwidth","screenheight");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
        
    //Seleccionar idioma por defecto del evento. Si el español está entre los disponibles, se toma esp por defecto
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE status=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
        if (substr_count($row["activelanguages"],"esp")>0)
            $defaultlang="esp";
    }
    if (isset($_REQUEST["sessionid"]))
        $appuserid = isSessionValid($db, $_REQUEST["sessionid"]);
        
    //Si el usuario es logueado buscar el idioma favorito
    $favoritelang="";
    if (isset($_REQUEST["sessionid"])){
        $userid=isSessionValid($db,$_REQUEST["sessionid"]);
        $sql="SELECT favoritelanguage ".
            " FROM appusers WHERE id=".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc()) 
            $favoritelang=$row["favoritelanguage"];
    }
    // Si est¨¢ logueado buscar si el idioma favorito est¨¢ entre los idiomas disponibles del evento
    //sino est¨¢, se deja el idioma por defecto del evento
    $foundmylanguage=false;
    if (isset($_REQUEST["sessionid"])) 
        foreach ($language as $valor) 
            if ($valor==$favoritelang) {
                $foundmylanguage=true;                    
                break;
            }
    if ($foundmylanguage) 
        $defaultlang=$favoritelang;

    //** query para obtener los panelistas
    $sqlp=   "SELECT P.id, CONCAT_WS(' ',P.name,P.surname) AS fullname, tags, ".
            "company, position_esp, position_eng, position_por, dsc_esp, dsc_eng, dsc_por, ".
            "email, website, facebook, twitter, instagram, linkedin, P.imagetype ".
            "   FROM activitypanelists AP ".
            "   INNER JOIN panelists P ON P.id=AP.panelistid ".
            "   WHERE  AP.activityid=".$_REQUEST["activityid"];
    $arraypanelists=array();
    if (!$rsp=$db->query($sqlp))
        badEnd("500", array("sql"=>$sqlp,"msg"=>$db->error));
    while ($rowp = $rsp->fetch_assoc()){
        $estructura= new stdClass;
        $estructura->id=(integer)$rowp["id"];
        $estructura->name=$rowp["fullname"];
        $estructura->fullname=$rowp["fullname"];
        $ext=substr($rowp["imagetype"],strpos($rowp["imagetype"],"/")+1);
        if ($ext=="jpeg")
            $ext="jpg";
        if ($ext)
            $estructura->image=$homeurl."../cms/uploads/panelists/".$rowp["id"].".".$ext;
        else
            $estructura->image="";
        $estructura->tags=nvl($rowp["tags"],"");
        $estructura->company=nvl($rowp["company"],"");
        $estructura->position=nvl($rowp["position_".$defaultlang],"");
        $estructura->dsc=nvl($rowp["dsc_".$defaultlang],"");
        $estructura->email=nvl($rowp["email"],"");
        $estructura->website=nvl($rowp["website"],"");
        $estructura->facebook=nvl($rowp["facebook"],"");
        $estructura->twitter=nvl($rowp["twitter"],"");
        $estructura->instagram=nvl($rowp["instagram"],"");
        $estructura->linkedin=nvl($rowp["linkedin"],"");
        $arraypanelists[]=$estructura;
    }
    //**
    //** query para obtener los attachments
    $sqla=  "SELECT id, type, name, mimetype,activityid ".
            "FROM activityattachments AA ".
            "WHERE AA.activityid=".$_REQUEST["activityid"];    
    $arrayattachments=array();
    if (!$rsa=$db->query($sqla))
        badEnd("500", array("sql"=>$sqla,"msg"=>$db->error));
    while ($rowa = $rsa->fetch_assoc()){
        $attach= new stdClass;
        $attach->id=(integer)$rowa["id"];
        $attach->type=$rowa["type"];
        $attach->name=$rowa["name"];        
        if ($rowa["type"]==2)
            $attach->file=array();
        else {
            $attach->file=new stdClass;
            $attach->file->type=$rowa["mimetype"];
            $ext=".".substr($rowa["mimetype"],strrpos($rowa["mimetype"],"/")+1);
            if ($ext==".jpeg")
                $ext=".jpg";
            $filename=$rowa["id"].$ext;
            $attach->file->url=$homeurl."../cms/uploads/activities/".$_REQUEST["activityid"]."/".$filename;
        }
        $arrayattachments[]=$attach;
    }    
    //**
    //** query para obtener el rating
    if (isset($_REQUEST["sessionid"])) {
        $sqlr=  "SELECT AVG(rating) average FROM activityratings ".
                " WHERE activityid=".$_REQUEST["activityid"] . " AND appuserid=".$appuserid;
        if (!$rsr=$db->query($sqlr))
            badEnd("500", array("sql"=>$sqlr,"msg"=>$db->error));
        if ($rowr = $rsr->fetch_assoc())
            $rating=$rowr["average"];
    }
    else
        $rating=null;
    //**
    //** query para obtener el note
    if (isset($_REQUEST["sessionid"])) {
        $sqln=  "SELECT note FROM activitynotes WHERE activityid=".$_REQUEST["activityid"]." AND appuserid=".$appuserid;
        if (!$rsn=$db->query($sqln))
            badEnd("500", array("sql"=>$sqln,"msg"=>$db->error));
        if ($rown = $rsn->fetch_assoc())
            $note=$rown["note"];
    }
    else
        $note=null;
    //**    
    
    // query principal    
    $sql=   "SELECT A.id, A.name_esp, A.name_eng, A.name_por, A.dsc_esp, A.dsc_eng, A.dsc_por, ".
            "DATE_FORMAT(datefrom,'%Y-%m-%d') AS date, ".
            "DATE_FORMAT(datefrom,'%d/%m/%Y') AS dateformatted, ".
            "DATE_FORMAT(datefrom,'%d %M, %Y') AS formatted, ".            
            "DATE_FORMAT(datefrom,'%h:%i %p') AS start, ".            
            "DATE_FORMAT(dateto,'%h:%i %p') AS end, ".
            "S.id as siteid, S.name_esp AS sitename_esp, S.name_eng AS sitename_eng, S.name_por AS sitename_por ".
            "FROM activities A INNER JOIN sites S ON S.id=A.siteid WHERE A.id=".$_REQUEST["activityid"];
            
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    // Se llena la estructura
    $records = array();
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name_".$defaultlang],"");
        $record->dsc=nvl($row["dsc_".$defaultlang],"");
        $record->date=$row["dateformatted"];
        $record->timefrom=$row["start"];
        $record->timeto=$row["end"];
        $record->site=new stdClass;
        $record->site->id=(integer)$row["siteid"];
        $record->site->name=nvl($row["sitename_".$defaultlang],"");
        $record->rating=(float)nvl($rating,"");
        $record->note=nvl($note,"");
        $record->panelists=$arraypanelists;
        $record->attachments=$arrayattachments;
    }

    $out= new stdClass;
    //$out->sql =$sqla;
    $out->entry =$record;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>